<?php

namespace App\Http\Controllers\Admin\Layanan\konferensi;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\GuruModel;
use App\Models\Stakeholder\WakaKesiswaanModel;
use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Stakeholder\KonselorModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\Konferensi\KonKegiatanModel;
use App\Models\Layanan\Konferensi\KonRPLModel;
use App\Models\Layanan\Konferensi\KonBeritaAcaraModel;

use PhpOffice\PhpWord\TemplateProcessor;

class KonferensiBeritaAcaraController extends Controller
{
    private $views      = 'admin/layanan/konferensi/konferensi_beritaAcara';
    private $url        = 'admin/layanan/lainnya/konferensi/berita-acara';
    private $url2       = 'admin/layanan/lainnya/konferensi/kegiatan';
    private $title      = 'Halaman Konferensi Berita Acara';

public function __construct()
    {
        createLogActivity();
        $this->mPeriode             = new PeriodeModel();

        $this->mPerpusSekolah       = new SekolahModel();
        $this->mPerpusKelas         = new KelasModel();
        $this->mPerpusJurusan       = new JurusanModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();

        $this->mGuru                = new GuruModel();
        $this->mWakaKesiswaan       = new WakaKesiswaanModel();
        $this->mWali                = new SekolahWaliModel();
        $this->mKonselor            = new KonselorModel();
        $this->mKepsek              = new KepsekModel();

        $this->mSiswa               = new SiswaModel();

        $this->mKonKegiatan         = new KonKegiatanModel();
        $this->mKonBeritaAcara      = new KonBeritaAcaraModel();
        $this->mKonRPL              = new KonRPLModel();
    }

    public function create($id)
    {
        $kegiatan       = $this->mKonKegiatan->where('kode_unik', $id)->first();
        
        $wherehehe = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek         = $this->mKepsek->where($wherehehe)->first();
        $kesiswaan      = $this->mWakaKesiswaan->where($wherehehe)->first();
        $konselor       = $this->mKonselor->where($wherehehe)->get();
        
        $konrpl         = $this->mKonRPL->where('idLKKegiatan', $kegiatan['id'])->first();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Konferensi Berita Acara',
            'id'            => $id,
            'konselor'      => $konselor,
            'kepsek'        => $kepsek,
            'kegiatan'      => $kegiatan,
            'kesiswaan'     => $kesiswaan,
            'konrpl'        => $konrpl,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request, $id)
    {
        $kegiatan   = $this->mKonKegiatan->where('kode_unik', $id)->first();
        $siswa      = $this->mSiswa->where('id', $kegiatan['idSiswa'])->first();

        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };

        $wherehehe = [
            'status'        => 1,
            'idPKKode'      => $siswa['idPKKode']
        ];
        $wali       = $this->mWali->where($wherehehe)->first();
        if(!isset($wali)){
            return redirect("$this->url")->with('gagal', 'Wali belum di set');
        };

        $wherehehehe = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek         = $this->mKepsek->where($wherehehehe)->first();
        if(!isset($kepsek)){
            return redirect("$this->url")->with('gagal', 'Kepsek belum di set');
        };
        $kesiswaan      = $this->mWakaKesiswaan->where($wherehehehe)->first();
        if(!isset($kesiswaan)){
            return redirect("$this->url")->with('gagal', 'Kesiswaan belum di set');
        };

        $isianTanggal = $request->isian_tanggal;  
        $isianTanggalnew = date("d", strtotime($isianTanggal));

        $isianBulan = $request->isian_tanggal;  
        $isianBulannew = date("m", strtotime($isianBulan));

        $isianTahun = $request->isian_tanggal;  
        $isianTahunnew = date("Y", strtotime($isianTahun));

        $dataBeritaAcara = [
            'idLKKegiatan'          => $kegiatan['id'],
            'idSWali'               => $wali['id'],
            'idSKepsek'             => $kepsek['id'],
            'idSKonselor'           => $konselor['id'],
            'idSKesiswaan'          => $kesiswaan['id'],
            'isian_hari'            => $request->isian_hari,
            'isian_tanggal'         => $isianTanggalnew,
            'isian_bulan'           => $isianBulannew,
            'isian_tahun'           => $isianTahunnew,
            'isian_dilaksanakan'    => $request->isian_dilaksanakan,
            'isian_pukuld'          => $request->isian_pukuld,
            'isian_pukuls'          => $request->isian_pukuls,
            'isian_ruang'           => $request->isian_ruang,
            'arrayPihak'            => $request->arrayPihak,
            'isian_kasus'           => $request->isian_kasus,
            'isian_catatan'         => $request->isian_catatan,
            'isian_solusi'          => $request->isian_solusi,
        ];
        $this->mKonBeritaAcara->create($dataBeritaAcara);
        $dataStatus = [
            'status'    => 2 // update semua statusya jadi 0
        ];

        $this->mKonKegiatan->where('kode_unik', $id)->update($dataStatus);
        return redirect("$this->url2")->with('sukses', 'Data Konferensi Berita Acara berhasil di tambahkan');
    }

    public function show($id)
    {
        // Get Data
        $konberitaacara = $this->mKonBeritaAcara->where('id', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'url2'          => $this->url2,
            'page'          => 'Data Konferensi Berita Acara',
            'konberitaacara'=> $konberitaacara,
        ];
        return view($this->views . "/show", $data);
    }

    public function download(request $request)
    {
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $konberitaacara = $this->mKonBeritaAcara->where('id', $request->id)->first();
        // dd($mundur);
        $datakonberitaacara = [
            'KopSurat'              => $sekolah->logo,
            'isian_hari'            => $konberitaacara->isian_hari,
            'isian_tanggal'         => $konberitaacara->isian_tanggal, 
            'isian_bulan'           => $konberitaacara->isian_bulan, 
            'isian_tahun'           => $konberitaacara->isian_tahun, 
            'isian_dilaksanakan'    => $konberitaacara->isian_dilaksanakan, 
            'isian_pukuld'          => $konberitaacara->isian_pukuld, 
            'isian_pukuls'          => $konberitaacara->isian_pukuls, 
            'isian_ruang'           => $konberitaacara->isian_ruang, 
            'idSiswa'               => $konberitaacara->konkegiatan->siswa->nama, 
            'nisn'                  => $konberitaacara->konkegiatan->siswa->nisn, 
            'idPKKode'              => $konberitaacara->konkegiatan->kelaskode->kelas->nama.' '.$konberitaacara->konkegiatan->kelaskode->kelas->jurusan->nama.' '.$konberitaacara->konkegiatan->kelaskode->nama,
            'arrayPihak'            => $konberitaacara->arrayPihak,
            'isian_kasus'           => $konberitaacara->isian_kasus,
            'isian_catatan'         => $konberitaacara->isian_catatan,
            'isian_solusi'          => $konberitaacara->isian_solusi,
            'namaKonselor'          => $konberitaacara->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'           => $konberitaacara->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'namaKepsek'            => $konberitaacara->kepsek->guru->nama ?? 'Kepsek belum di SET',
            'nipKepsek'             => $konberitaacara->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'namaWakaKesiswaan'     => $konberitaacara->kesiswaan->guru->nama ?? 'Kesiswaan belum di SET',
            'nipWakaKesiswaan'      => $konberitaacara->kesiswaan->guru->nip ?? 'Kesiswaan belum di SET',
            'namaWali'              => $konberitaacara->wali->guru->nama ?? 'Wali belum di SET',
            'nipWali'               => $konberitaacara->wali->guru->nip ?? 'Wali belum di SET',
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/konferensi_kasus/konferensikasus_beritaacara.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$datakonberitaacara['KopSurat'], 'width' => 400, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('isian_hari', $datakonberitaacara['isian_hari']); 
        $templateProcessor->setValue('isian_tanggal', $datakonberitaacara['isian_tanggal']);
        $templateProcessor->setValue('isian_bulan', $datakonberitaacara['isian_bulan']);
        $templateProcessor->setValue('isian_tahun', $datakonberitaacara['isian_tahun']);
        $templateProcessor->setValue('isian_dilaksanakan', $datakonberitaacara['isian_dilaksanakan']);
        $templateProcessor->setValue('isian_pukuld', $datakonberitaacara['isian_pukuld']);
        $templateProcessor->setValue('isian_pukuls', $datakonberitaacara['isian_pukuls']);
        $templateProcessor->setValue('isian_ruang', $datakonberitaacara['isian_ruang']);
        $templateProcessor->setValue('idSiswa', $datakonberitaacara['idSiswa']);
        $templateProcessor->setValue('nisn', $datakonberitaacara['nisn']);
        $templateProcessor->setValue('idPKKode', $datakonberitaacara['idPKKode']);
        $templateProcessor->setValue('arrayPihak', $datakonberitaacara['arrayPihak']);
        $templateProcessor->setValue('isian_kasus', $datakonberitaacara['isian_kasus']);
        $templateProcessor->setValue('isian_catatan', $datakonberitaacara['isian_catatan']);
        $templateProcessor->setValue('isian_solusi', $datakonberitaacara['isian_solusi']);
        $templateProcessor->setValue('namaKonselor', $datakonberitaacara['namaKonselor']);
        $templateProcessor->setValue('nipKonselor', $datakonberitaacara['nipKonselor']); 
        $templateProcessor->setValue('namaKepsek', $datakonberitaacara['namaKepsek']);
        $templateProcessor->setValue('nipKepsek', $datakonberitaacara['nipKepsek']); 
        $templateProcessor->setValue('namaWakaKesiswaan', $datakonberitaacara['namaWakaKesiswaan']);
        $templateProcessor->setValue('nipWakaKesiswaan', $datakonberitaacara['nipWakaKesiswaan']); 
        $templateProcessor->setValue('namaWali', $datakonberitaacara['namaWali']);
        $templateProcessor->setValue('nipWali', $datakonberitaacara['nipWali']); 
        $fileName = 'konferensikasus_beritaacara'; // nama filenya
        
        

        // biar bisa dunlud
        $templateProcessor->saveAs($fileName . '.docx');
        return response()->download($fileName . '.docx')->deleteFileAfterSend(true);
        // dd($datamundur);
    }
}
