<?php

namespace App\Http\Controllers\Admin\Layanan\Homevisit;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;
use App\Models\Master\JabatanModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\Homevisit\HomevisitRpl;
use App\Models\Layanan\Homevisit\HomevisitKegiatan;
use App\Models\Layanan\Homevisit\HomevisitTu;
use App\Models\Layanan\Homevisit\HomevisitEvaluasi;

class HomevisitTuController extends Controller
{
    private $views      = 'admin/layanan/homevisit/homevisit_tu';
    private $url       = 'admin/layanan/lainnya/home/visit/tu';
    private $url2        = 'admin/layanan/lainnya/home/visit';
    private $title      = 'Halaman Home Visit TU';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode                 = New PeriodeModel();
        $this->mJabatan                 = New JabatanModel();
        
        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mKelasKode               = new KelasKodeModel();
        $this->mPerpusSekolah           = new SekolahModel();

        $this->mKepsek                  = New KepsekModel();
        $this->mKonselor                = New KonselorModel();
        $this->mGuru                    = New GuruModel();

        $this->mSiswa                   = New SiswaModel();
        $this->mOrtu                    = New OrtuModel();

        $this->mHomevisitRpl            = new HomevisitRpl();
        $this->mHomevisitKegiatan       = new HomevisitKegiatan();
        $this->mHomevisitTu             = new HomevisitTu();
    }

    public function create($id)
    {
        $homevisit_kegiatan       = $this->mHomevisitKegiatan->where('id', $id)->first();

        $where = [
            'idPsekolah' => session()->get('idPSekolah'),
            'status'     => '1'
        ];
        $guru       = $this->mGuru->where($where)->get();
        $jabatan    = $this->mJabatan->get();
        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'url2'                   => $this->url2,
            'page'                  => 'Tambah Data Home Visit TU',
            'guru'                  => $guru,
            'jabatan'               => $jabatan,
            'homevisit_kegiatan'    => $homevisit_kegiatan,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request, $id)
    {
        $dataHomevisitTu = [
            'idLHKegiatan'          => $id,
            'arrayIdSGuru'               => $request->idSGuru,
            'arrayJabatan'             => $request->idJabatan,
        ];
        $this->mHomevisitTu->create($dataHomevisitTu);
        $dataStatus = [
            'status'    => 2 // update semua statusya jadi 0
        ];
        // cari yang statusnya 1, terus semua diupdate jadi 0
        // dd($dataHomevisitTu); die();
        $this->mHomevisitKegiatan->where('id', $id)->update($dataStatus);
        return redirect("$this->url2")->with('sukses', 'Data Homevisit TU berhasil di tambahkan');
    }

    public function show($id)
    {
        $homevisit_tu = $this->mHomevisitTu->where('id', $id)->first();
        
        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'url2'               => $this->url2,
            'page'              => 'Data Home Visit Tu',
            'homevisit_tu'      => $homevisit_tu,
        ];
        return view($this->views . "/show", $data);
    }

    public function download(Request $request)
    {
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $homevisit_tu = $this->mHomevisitTu->where('id', $request->id)->first();
        $homevisit_kegiatan = $this->mHomevisitKegiatan->where('id', $homevisit_tu['idLHKegiatan'])->first();
        $siswa = $this->mSiswa->where('id', $homevisit_kegiatan['idSiswa'])->first();
        $ortu = $this->mOrtu->where('idSiswa', $siswa['id'])->first();
        if(!isset($ortu)){
            return redirect("$this->url")->with('gagal', 'Data Ortu tidak ditemukan');
        };
        // dd($mundur);
        
        $dataHomevisitTU = [
            'KopSurat'      => $sekolah->logo,
            'namaSiswa'     => $siswa->nama,
            'kelasSiswa'    => $siswa->kelaskode->kelas->nama.' '.$siswa->kelaskode->jurusan->nama.' '.$siswa->kelaskode->nama,
            'nisn'          => $siswa->nisn,
            'ortu'          => $ortu->nama,
            'alamat'        => $ortu->alamat,
            'pekerjaan'     => $ortu->pekerjaan->nama,
            'guru'          => $homevisit_tu->guru->nama,
            'jabatanGuru'   => $homevisit_tu->jabatan->nama,
        ];
        // echo json_encode($dataHomevisitTU); die;
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/home_visit/homevisit_tu.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataHomevisitTU['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('namaSiswa', $dataHomevisitTU['namaSiswa']); 
        $templateProcessor->setValue('kelasSiswa', $dataHomevisitTU['kelasSiswa']); 
        $templateProcessor->setValue('nisn', $dataHomevisitTU['nisn']); 
        $templateProcessor->setValue('namaOrtu', $dataHomevisitTU['ortu']); 
        $templateProcessor->setValue('alamatOrtu', $dataHomevisitTU['alamat']); 
        $templateProcessor->setValue('pekerjaan', $dataHomevisitTU['pekerjaan']); 
        $templateProcessor->setValue('guru', $dataHomevisitTU['guru']); 
        $templateProcessor->setValue('jabatanGuru', $dataHomevisitTU['jabatanGuru']);
        $fileName = 'Home Visit TU'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs($fileName . '.docx');
        return response()->download($fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataTartib);
    }
}
