<?php

namespace App\Http\Controllers\Admin\Layanan\Homevisit;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;
use App\Models\Master\JabatanModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\OrtuModel;

use App\Models\Layanan\Homevisit\HomevisitRpl;
use App\Models\Layanan\Homevisit\HomevisitKegiatan;
use App\Models\Layanan\Homevisit\HomevisitTu;
use App\Models\Layanan\Homevisit\HomevisitEvaluasi;

class HomevisitKegiatanController extends Controller
{
    private $views      = 'admin/layanan/homevisit/homevisit_kegiatan';
    private $url        = 'admin/layanan/lainnya/home/visit';
    private $url2       = 'admin/layanan/lainnya/home/visit/rpl';
    private $url3       = 'admin/layanan/lainnya/home/visit/tu';
    private $url4       = 'admin/layanan/lainnya/home/visit/evaluasi';
    private $title      = 'Halaman Home Visit Kegiatan';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode                 = New PeriodeModel();
        $this->mJabatan                 = New JabatanModel();
        
        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mKelasKode               = new KelasKodeModel();
        $this->mPerpusSekolah           = new SekolahModel();

        $this->mKepsek                  = New KepsekModel();
        $this->mKonselor                = New KonselorModel();
        $this->mGuru                    = New GuruModel();

        $this->mSiswa                   = New SiswaModel();
        $this->mOrtu                    = New OrtuModel();

        $this->mHomevisitRpl            = new HomevisitRpl();
        $this->mHomevisitKegiatan       = new HomevisitKegiatan();
        $this->mHomevisitTu             = new HomevisitTu();
        $this->mHomevisitEvaluasi       = new HomevisitEvaluasi();
    }

    public function index()
    {
        $wherenyaa = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
        ];
        $homevisit_kegiatan      = $this->mHomevisitKegiatan->where($wherenyaa)->get();

        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'page'                  => 'Data Home Visit Kegiatan',
            'homevisit_kegiatan'    => $homevisit_kegiatan,
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $periode    = $this->mPeriode->get();
        $ortu       = $this->mOrtu->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Home Visit Kegiatan',
            'periode'       => $periode,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $ortu = $this->mOrtu->where('idSiswa', $siswa['id'])->first();
        if(!isset($ortu)){
            return redirect("$this->url")->with('gagal', 'Data Ortu tidak ditemukan');
        };
        $whereKep = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek             = $this->mKepsek->where($whereKep)->first();
        if(!isset($kepsek)){
            return redirect("$this->url")->with('gagal', 'Kepsek belum di set');
        };
        
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };

        $suratWaktu             = $request->surat_waktu;  
        $suratWaktunew          = date("d-m-Y", strtotime($suratWaktu));

        $isianWaktu             = $request->isian_waktu;  
        $isianWaktunew          = date("d-m-Y", strtotime($isianWaktu));

        $dataHomevisitKegiatan = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
            'idPKKode'      => $request->idPKKode,
            'idPPeriode'    => session()->get('idPPeriode'),
            'idSiswa'       => $request->idSiswa,
            'kode_unik'     => strtoupper(bin2hex(random_bytes(3))),
            'status'        => 1
        ];
        $homevisit_kegiatan     = $this->mHomevisitKegiatan->create($dataHomevisitKegiatan);
        $dataHomevisitRpl = [
            'idLHKegiatan'          => $homevisit_kegiatan['id'],
            'idOrtu'                => $ortu['id'],
            'idSKonselor'           => session()->get('idSKonselor'),
            'idSKepsek'             => $kepsek['id'],
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_judul'           => $request->isian_judul,
            'isian_bidang'          => $request->isian_bidang,
            'isian_fungsi'          => $request->isian_fungsi,
            'isian_tujuan'          => $request->isian_tujuan,
            'isian_hasil'           => $request->isian_hasil,
            'isian_gambaran'        => $request->isian_gambaran,
            'isian_tempat'          => $request->isian_tempat,
            'isian_waktu'           => $isianWaktunew,
            'isian_tanggal'         => $request->isian_tanggal,
            'isian_semester'        => $request->isian_semester,
            'isian_petugas'         => $request->isian_petugas,
            'isian_anggota'         => $request->isian_anggota,
            'isian_keterangan'      => $request->isian_keterangan,
            'isian_hasilPertemuan'  => $request->isian_hasilPertemuan,
            'isian_rencana'         => $request->isian_rencana,
            'isian_catatan'         => $request->isian_catatan,
        ];
        // dd($dataHomevisitRpl); die();
        $this->mHomevisitRpl->create($dataHomevisitRpl);
        
        return redirect("$this->url")->with('sukses', 'Data Layanan Homevisit Rpl berhasil di tambahkan');
    }

    public function show($id)
    {
        // Get Data
        $homevisit_kegiatan        = $this->mHomevisitKegiatan->where('kode_unik', $id)->first();
        $homevisit_rpl             = $this->mHomevisitRpl->where('idLHKegiatan', $homevisit_kegiatan->id)->first();
        $homevisit_tu              = $this->mHomevisitTu->where('idLHKegiatan', $homevisit_kegiatan->id)->first();
        // $guru                      = $this->mGuru->where('id', $homevisit_tu['arrayIdSGuru'])->first(); // ambil data guru berdasarkan homvisit tu
        // $jabatan                   = $this->mJabatan->where('id', $homevisit_tu['arrayJabatan'])->first(); // ambil data guru berdasarkan homvisit tu
        
        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'url2'                   => $this->url2,
            'url3'                   => $this->url3,
            'url4'                   => $this->url4,
            'page'                  => 'Detail Data Home Visit Kegiatan',
            'id'                    => $id,
            'homevisit_rpl'         => $homevisit_rpl,
            'homevisit_kegiatan'    => $homevisit_kegiatan,
            'homevisit_tu'          => $homevisit_tu,
            // 'guru'                  => $guru,
            // 'jabatan'               => $jabatan,
        ];
        if ($homevisit_kegiatan['status'] == 2){
            $homevisit_tu               = $this->mHomevisitTu->where('idLHKegiatan', $homevisit_kegiatan['id'])->first();
            $guru                      = $this->mGuru->where('id', $homevisit_tu['arrayIdSGuru'])->first(); // ambil data guru berdasarkan homvisit tu
            $jabatan                   = $this->mJabatan->where('id', $homevisit_tu['arrayJabatan'])->first(); // ambil data guru berdasarkan homvisit tu
            $data = [
                'title'                 => $this->title,
                'url'                   => $this->url,
                'url2'                   => $this->url2,
                'url3'                   => $this->url3,
                'url4'                   => $this->url4,
                'page'                  => 'Detail Data Home Visit Kegiatan',
                'id'                    => $id,
                'homevisit_rpl'         => $homevisit_rpl,
                'homevisit_kegiatan'    => $homevisit_kegiatan,
                'homevisit_tu'          => $homevisit_tu,
                'guru'                  => $guru,
                'jabatan'               => $jabatan,
            ];
            $data['homevisit_tu']       = $homevisit_tu;
        }else if ($homevisit_kegiatan['status'] == 3){
            $homevisit_evaluasi               = $this->mHomevisitEvaluasi->where('idLHKegiatan', $homevisit_kegiatan['id'])->first();
            $guru                      = $this->mGuru->where('id', $homevisit_tu['arrayIdSGuru'])->first(); // ambil data guru berdasarkan homvisit tu
            $jabatan                   = $this->mJabatan->where('id', $homevisit_tu['arrayJabatan'])->first(); // ambil data guru berdasarkan homvisit tu
            $data = [
                'title'                 => $this->title,
                'url'                   => $this->url,
                'url2'                   => $this->url2,
                'url3'                   => $this->url3,
                'url4'                   => $this->url4,
                'page'                  => 'Detail Data Home Visit Kegiatan',
                'id'                    => $id,
                'homevisit_rpl'         => $homevisit_rpl,
                'homevisit_kegiatan'    => $homevisit_kegiatan,
                'homevisit_tu'          => $homevisit_tu,
                'guru'                  => $guru,
                'jabatan'               => $jabatan,
            ];
            $data['homevisit_evaluasi']       = $homevisit_evaluasi;
        }
        // echo json_encode($guru); die;

        return view($this->views . "/show", $data);
    }
}
