<?php

namespace App\Http\Controllers\Admin\Layanan\FormIjin;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;

use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruPiketModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\FormIjin\FormIjinMasukModel;

use PhpOffice\PhpWord\TemplateProcessor;

class IjinMasukController extends Controller
{
    private $views      = 'admin/layanan/form_ijin/ijin_masukKelas';
    private $url        = 'admin/layanan/form-ijin/masuk/kelas';
    private $title      = 'Halaman Form Ijin Masuk Kelas';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mKonselor        = New KonselorModel();
        $this->mPiket           = New GuruPiketModel();
        $this->mPeriode         = New PeriodeModel();
        $this->mIjinMasuk       = New FormIjinMasukModel();
        $this->mSiswa           = New SiswaModel();
        $this->mPerpusSekolah   = new SekolahModel();
    }

    public function index()
    {
        $ijinMasuk = $this->mIjinMasuk->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Ijin Masuk Kelas',
            'ijinMasuk'     => $ijinMasuk
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $periode    = $this->mPeriode->get();
        $konselor   = $this->mKonselor->where('idPSekolah', session()->get('idPSekolah'))->get();
        $where = [
            'status' => 1,
            'idPSekolah' => session()->get('idPSekolah'),
        ];
        $piket      = $this->mPiket->where($where)->get();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Permintaan Surat Ijin Masuk Kelas',
            'periode'       => $periode,
            'gurukonselor'  => $konselor,
            'piket'         => $piket,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };

        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));  
 
        $dataIjinMasuk = [
            'idPSekolah'            => session()->get('idPSekolah'),
            'idPKKode'              => $request->idPKKode,
            'idPPeriode'            => session()->get('idPPeriode'),
            'idSiswa'               => $request->idSiswa,
            'idSKonselor'           => $konselor['id'],
            'idSPiket'              => $request->idSPiket,
            'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_pelajaran'       => $request->isian_pelajaran,
            'isian_keterangan'      => $request->isian_keterangan,
        ];
        $this->mIjinMasuk->create($dataIjinMasuk);
        
        $ijinMasuk = $this->mIjinMasuk->where('kode_unik', $dataIjinMasuk['kode_unik'])->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Ijin Masuk Kelas',
            'ijinMasuk'     => $ijinMasuk,
        ];
        return view($this->views . "/show", $data);
    }

    public function show($id)
    {
        $ijinMasuk = $this->mIjinMasuk->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Ijin Masuk Kelas',
            'ijinMasuk'    => $ijinMasuk,
        ];
        return view($this->views . "/show", $data);
        // dd($ijinMasuk);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $ijinMasuk = $this->mIjinMasuk->where('kode_unik', $id)->first();
        // dd($ijinMasuk);
        $dataijinMasuk = [
            'KopSurat'          => $sekolah->logo,
            'idPKKode'          => $ijinMasuk->kelaskode->kelas->nama.' '.$ijinMasuk->kelaskode->kelas->jurusan->nama.' '.$ijinMasuk->kelaskode->nama,
            'idSiswa'           => $ijinMasuk->siswa->nama,
            'nisSiswa'          => $ijinMasuk->siswa->nisn,
            'idSKonselor'       => $ijinMasuk->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'       => $ijinMasuk->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'idSPiket'          => $ijinMasuk->piket->guru->nama ?? 'Guru Piket belum di SET',
            'nipPiket'          => $ijinMasuk->piket->guru->nip ?? 'Guru Piket belum di SET',
            'surat_tempat'      => $ijinMasuk->surat_tempat,
            'surat_waktu'       => $ijinMasuk->surat_waktu, // tanggal surat
            'isian_pelajaran'   => $ijinMasuk->isian_pelajaran,
            'isian_keterangan'  => $ijinMasuk->isian_keterangan,
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/form_ijin/form_ijin_masukkelas.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataijinMasuk['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('kelasSiswa', $dataijinMasuk['idPKKode']); 
        $templateProcessor->setValue('namaSiswa', $dataijinMasuk['idSiswa']); 
        $templateProcessor->setValue('nisSiswa', $dataijinMasuk['nisSiswa']); 
        $templateProcessor->setValue('namaKonselor', $dataijinMasuk['idSKonselor']);
        $templateProcessor->setValue('nipKonselor', $dataijinMasuk['nipKonselor']); 
        $templateProcessor->setValue('namaPiket', $dataijinMasuk['idSPiket']);
        $templateProcessor->setValue('nipPiket', $dataijinMasuk['nipPiket']); 
        $templateProcessor->setValue('surat_tempat', $dataijinMasuk['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $dataijinMasuk['surat_waktu']);
        $templateProcessor->setValue('pelajaranKe', $dataijinMasuk['isian_pelajaran']);
        $templateProcessor->setValue('ket', $dataijinMasuk['isian_keterangan']);
        $fileName = 'form_ijin_masukkelas'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs($fileName . '.docx');
        return response()->download($fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataijinMasuk); 
    }

    public function edit($id){
        $ijinMasuk = $this->mIjinMasuk->where('kode_unik', $id)->first();
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Surat Ijin Masuk Kelas',
            'ijinMasuk'     => $ijinMasuk,
        ];

        return view($this->views . "/edit", $data);

    }

    public function update(Request $request, $id)
    {
        $dataUbah = $this->mIjinMasuk->where('kode_unik', $id)->first();

        if (isset($request->surat_waktu)) {
            $suratWaktu     = $request->surat_waktu;
            $suratWaktunew  = date("d-m-Y", strtotime($suratWaktu));
        } else {
            $suratWaktunew     = $dataUbah->surat_waktu;  
        }

        $dataIjinMasuk = [
            // yang dicomment yang tidak berubah ya
            // 'idPSekolah'            => session()->get('idPSekolah'),
            // 'idPKKode'              => $request->idPKKode,
            // 'idPPeriode'            => session()->get('idPPeriode'),
            // 'idSiswa'               => $request->idSiswa,
            // 'idSKepsek'             => $kepsek['id'],
            // 'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_keterangan'      => $request->isian_keterangan,
        ];
        // echo json_encode($dataIjinMasuk); die;
        $this->mIjinMasuk->where('kode_unik', $id)->update($dataIjinMasuk);

        return redirect("$this->url")->with('sukses', 'Data Surat Ijin Masuk Kelas untuk '.$dataUbah->siswa->nama.' berhasil di edit');
    }

    public function destroy($id)
    {
        $this->mIjinMasuk->where('kode_unik', $id)->delete();

        return redirect("$this->url")->with('sukses', 'Data Surat Ijin Masuk Kelas berhasil di hapus');
    }
}
