<?php

namespace App\Http\Controllers\Admin\Layanan\FormIjin;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;

use App\Models\Stakeholder\WakaKurikulumModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruPiketModel;

use App\Models\Layanan\FormIjin\FormIjinKeluarMasalModel;

use PhpOffice\PhpWord\TemplateProcessor;

class IjinKeluarMasalController extends Controller
{
    private $views      = 'admin/layanan/form_ijin/ijin_keluarMasal';
    private $url        = 'admin/layanan/form_ijin/ijin_keluarMasal';
    private $title      = 'Halaman Form Ijin Keluar Masal';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPerpusSekolah   = new SekolahModel();
        $this->mPeriode         = New PeriodeModel();

        $this->mKurikulum       = New WakaKurikulumModel();
        $this->mKonselor        = New KonselorModel();
        $this->mPiket           = New GuruPiketModel();

        $this->mIjinKeluarMasal = New FormIjinKeluarMasalModel();
    }

    public function index()
    {
        $ijinKeluarMasal = $this->mIjinKeluarMasal->where('idPSekolah', session()->get('idPSekolah'))->get();
        
        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Data Surat Ijin Keluar Masal',
            'ijinKeluarMasal'   => $ijinKeluarMasal,
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $periode    = $this->mPeriode->get();
        $konselor   = $this->mKonselor->where('idPSekolah', session()->get('idPSekolah'))->get();
        $where = [
            'status' => 1,
            'idPSekolah' => session()->get('idPSekolah'),
        ];
        $piket      = $this->mPiket->where($where)->get();
        $kurikulum  = $this->mKurikulum->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Permintaan Surat Ijin Keluar Masal',
            'periode'       => $periode,
            'gurukonselor'  => $konselor,
            'piket'         => $piket,
            'kurikulum'     => $kurikulum,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));  
        
        $isianTanggal = $request->isian_tanggal;  
        $isianTanggalNew = date("d-m-Y", strtotime($isianTanggal));  

        $dataIjinKeluarMasal = [
            'idPSekolah'            => session()->get('idPSekolah'),
            'idPKKode'              => $request->idPKKode,
            'idPPeriode'            => $request->idPPeriode,
            'arrayIdSiswa'          => $request->arrayIdSiswa,
            'idSKonselor'           => $request->idSKonselor,
            'idSPiket'              => $request->idSPiket,
            'idSKurikulum'          => $request->idSKurikulum,
            'kode_unik'             => strtoupper(bin2hex(random_bytes(3))),
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_hari'            => $request->isian_hari,
            'isian_tanggal'         => $isianTanggalNew,
            'isian_pelajaran'       => $request->isian_pelajaran,
            'isian_keterangan'      => $request->isian_keterangan,
        ];
        $this->mIjinKeluarMasal->create($dataIjinKeluarMasal);

        $ijinKeluarMasal = $this->mIjinKeluarMasal->where('kode_unik', $dataIjinKeluarMasal['kode_unik'])->first();
        
        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Data Surat Ijin Keluar Masal',
            'ijinKeluarMasal'   => $ijinKeluarMasal,
        ];
        return view($this->views . "/show", $data);
    }

    public function show($id)
    {
        $ijinKeluarMasal = $this->mIjinKeluarMasal->where('kode_unik', $id)->first();
        
        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Data Surat Ijin Keluar Masal',
            'dataIjinKeluarMasal'   => $ijinKeluarMasal,
        ];
        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $ijinKeluarMasal = $this->mIjinKeluarMasal->where('kode_unik', $id)->first();
        
        $dataIjinKeluarMasal = [
            'KopSurat'          => $sekolah->logo,
            'idPKKode'          => $ijinKeluarMasal->kelaskode->kelas->nama.' '.$ijinKeluarMasal->kelaskode->kelas->jurusan->nama.' '.$ijinKeluarMasal->kelaskode->nama,
            'arrayIdSiswa'      => $ijinKeluarMasal->siswa->nama,
            'isian_hari'        => $ijinKeluarMasal->isian_hari,
            'isian_tanggal'     => $ijinKeluarMasal->isian_tanggal,
            'isian_pelajaran'   => $ijinKeluarMasal->isian_pelajaran,
            'isian_keterangan'  => $ijinKeluarMasal->isian_keterangan,
            'surat_tempat'      => $ijinKeluarMasal->surat_tempat,
            'surat_waktu'       => $ijinKeluarMasal->surat_waktu,
            'idSPiket'          => $ijinKeluarMasal->piket->guru->nama,
            'nipPiket'          => $ijinKeluarMasal->piket->guru->nip,
            'idSKonselor'       => $ijinKeluarMasal->konselor->guru->nama,
            'nipKonselor'       => $ijinKeluarMasal->konselor->guru->nip,
            'idSKurikulum'      => $ijinKeluarMasal->kurikulum->guru->nama,
            'nipKurikulum'      => $ijinKeluarMasal->kurikulum->guru->nip,
        ];
        // pakai dari sini. sambil buka word coba.docx
        $templateProcessor = new TemplateProcessor('word-template/form_ijin/form_ijin_keluarmasal.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataIjinKeluarMasal['KopSurat'], 'width' => 600, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('kelasSiswa', $dataIjinKeluarMasal['idPKKode']); 
        $templateProcessor->setValue('namaSiswa', $dataIjinKeluarMasal['arrayIdSiswa']);
        $templateProcessor->setValue('hari', $dataIjinKeluarMasal['isian_hari']); 
        $templateProcessor->setValue('tanggalijin', $dataIjinKeluarMasal['isian_tanggal']); 
        $templateProcessor->setValue('pelajaran1', $dataIjinKeluarMasal['isian_pelajaran']); 
        $templateProcessor->setValue('pelajaran2', $dataIjinKeluarMasal['isian_pelajaran']); 
        $templateProcessor->setValue('ket', $dataIjinKeluarMasal['isian_keterangan']);
        $templateProcessor->setValue('surat_tempat', $dataIjinKeluarMasal['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $dataIjinKeluarMasal['surat_waktu']);
        $templateProcessor->setValue('namaKonselor', $dataIjinKeluarMasal['idSKonselor']);
        $templateProcessor->setValue('nipKonselor', $dataIjinKeluarMasal['nipKonselor']); 
        $templateProcessor->setValue('namaPiket', $dataIjinKeluarMasal['idSPiket']);
        $templateProcessor->setValue('nipPiket', $dataIjinKeluarMasal['nipPiket']); 
        $templateProcessor->setValue('namaWakaKurikulum', $dataIjinKeluarMasal['idSKurikulum']);
        $templateProcessor->setValue('nipWakaKurikulum', $dataIjinKeluarMasal['nipKurikulum']); 
        $fileName = 'form_ijin_keluar_masal'; // nama filenya
        
        // biar bisa dunlud
        $templateProcessor->saveAs($fileName . '.docx');
        return response()->download($fileName . '.docx')->deleteFileAfterSend(true);
    }

    public function update(Request $request, $id)
    {
        // 
    }

    public function destroy($id)
    {
        //
    }
}
