<?php

namespace App\Http\Controllers\Admin\Layanan\Alihtangan;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\AlihTangan\AlihTanganRplModel;
use App\Models\Layanan\AlihTangan\AlihTanganKegiatanModel;

class AlihtanganRplController extends Controller
{
    private $views      = 'admin/layanan/alihtangan/alihtangan_rpl';
    private $url        = 'admin/layanan/lainnya/alih-tangan/rpl';
    private $url2       = 'admin/layanan/lainnya/alih-tangan/kegiatan';
    private $title      = 'Halaman Layanan Alih Tangan Kasus';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode                 = New PeriodeModel();

        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mKelasKode               = new KelasKodeModel();
        $this->mPerpusSekolah           = new SekolahModel();

        $this->mKepsek                  = New KepsekModel();
        $this->mKonselor                = New KonselorModel();
        $this->mGuru                    = New GuruModel();

        $this->mSiswa                   = New SiswaModel();

        $this->mAlihtanganRpl           = new AlihTanganRplModel();
        $this->mAlihtanganKegiatan      = new AlihTanganKegiatanModel();
    }

    public function show($id)
    {
        // Get Data
        $alihtangan_rpl = $this->mAlihtanganRpl->where('id', $id)->first();
        
        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'url2'               => $this->url2,
            'page'              => 'Data Layanan Alih Tangan RPL',
            'alihtangan_rpl'    => $alihtangan_rpl,
        ];
        return view($this->views . "/show", $data);
    }

    public function download($id)
    {
        if (!cekKopSurat(session()->get('idPSekolah'))) {
            return redirect("admin/dashboard")->with('gagal', 'Kop Surat tidak ditemukan, mohon upload ulang melalui login Admin Sekolah');
        }
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $alihtangan_rpl = $this->mAlihtanganRpl->where('id', $id)->first();
        // dd($mundur);
        
        $dataAlihRpl = [
            'KopSurat'              => $sekolah->logo,
            'idPKKode'              => $alihtangan_rpl->alihkegiatan->kelaskode->kelas->nama.' '.$alihtangan_rpl->alihkegiatan->kelaskode->kelas->jurusan->nama.' '.$alihtangan_rpl->alihkegiatan->kelaskode->nama,
            'idSiswa'               => $alihtangan_rpl->alihkegiatan->siswa->nama,
            'namaKepsek'            => $alihtangan_rpl->kepsek->guru->nama ?? 'Kepsek belum di SET',
            'nipKepsek'             => $alihtangan_rpl->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'namaKonselor'          => $alihtangan_rpl->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'           => $alihtangan_rpl->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'surat_tempat'          => $alihtangan_rpl->surat_tempat,
            'surat_waktu'           => $alihtangan_rpl->surat_waktu,
            'isian_judul'           => $alihtangan_rpl->isian_judul,
            'isian_bidang'          => $alihtangan_rpl->isian_bidang,
            'isian_fungsi'          => $alihtangan_rpl->isian_fungsi,
            'isian_tujuan'          => $alihtangan_rpl->isian_tujuan,
            'isian_hasil'           => $alihtangan_rpl->isian_hasil,
            'isian_gambaran'        => $alihtangan_rpl->isian_gambaran,
            'isian_darikepada'      => $alihtangan_rpl->isian_darikepada,
            'isian_alasan'          => $alihtangan_rpl->isian_alasan,
            'isian_tanggal'         => $alihtangan_rpl->isian_tanggal,
            'isian_semester'        => $alihtangan_rpl->isian_semester,
            'isian_bahan'           => $alihtangan_rpl->isian_bahan,
            'isian_rencana'         => $alihtangan_rpl->isian_rencana,
            'isian_catatan'         => $alihtangan_rpl->isian_catatan,
        ];
        $templateProcessor = new TemplateProcessor('word-template/alih_tangan/satuan_alihtangan_rpl.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataAlihRpl['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('namaSiswa', $dataAlihRpl['idSiswa']); 
        $templateProcessor->setValue('isian_judul', $dataAlihRpl['isian_judul']); 
        $templateProcessor->setValue('isian_bidang', $dataAlihRpl['isian_bidang']);
        $templateProcessor->setValue('isian_fungsi', $dataAlihRpl['isian_fungsi']); 
        $templateProcessor->setValue('isian_tujuan', $dataAlihRpl['isian_tujuan']);
        $templateProcessor->setValue('isian_hasil', $dataAlihRpl['isian_hasil']);
        $templateProcessor->setValue('isian_gambaran', $dataAlihRpl['isian_gambaran']);
        $templateProcessor->setValue('isian_darikepada', $dataAlihRpl['isian_darikepada']);
        $templateProcessor->setValue('isian_alasan', $dataAlihRpl['isian_alasan']);
        $templateProcessor->setValue('isian_tanggal', $dataAlihRpl['isian_tanggal']);
        $templateProcessor->setValue('isian_semester', $dataAlihRpl['isian_semester']);
        $templateProcessor->setValue('isian_bahan', $dataAlihRpl['isian_bahan']);
        $templateProcessor->setValue('isian_rencana', $dataAlihRpl['isian_rencana']);
        $templateProcessor->setValue('isian_catatan', $dataAlihRpl['isian_catatan']);
        $templateProcessor->setValue('suratTempat', $dataAlihRpl['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $dataAlihRpl['surat_waktu']);
        $templateProcessor->setValue('namaKepsek', $dataAlihRpl['namaKepsek']);
        $templateProcessor->setValue('nipKepsek', $dataAlihRpl['nipKepsek']);
        $templateProcessor->setValue('namaKonselor', $dataAlihRpl['namaKonselor']);
        $templateProcessor->setValue('nipKonselor', $dataAlihRpl['nipKepsek']);
        $fileName = 'RENCANA PELAYANAN BIMBINGAN KONSELING ALIH TANGAN KASUS'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs($fileName . '.docx');
        return response()->download($fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataTartib);
    }
}
