<?php

namespace App\Http\Controllers\Admin\Layanan\Alihtangan;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\AlihTangan\AlihTanganRplModel;
use App\Models\Layanan\AlihTangan\AlihTanganPengantarModel;
use App\Models\Layanan\AlihTangan\AlihTanganKegiatanModel;

class AlihtanganPengantarController extends Controller
{
    private $views      = 'admin/layanan/alihtangan/alihtangan_pengantar';
    private $url        = 'admin/layanan/lainnya/alih-tangan/pengantar';
    private $url2       = 'admin/layanan/lainnya/alih-tangan/kegiatan';
    private $title      = 'Halaman Layanan Alih Tangan Pengantar';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode                 = New PeriodeModel();
        
        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mKelasKode               = new KelasKodeModel();
        $this->mPerpusSekolah           = new SekolahModel();

        $this->mKepsek                  = New KepsekModel();
        $this->mKonselor                = New KonselorModel();
        $this->mGuru                    = New GuruModel();

        $this->mSiswa                   = New SiswaModel();

        $this->mAlihtanganRpl           = new AlihTanganRplModel();
        $this->mAlihtanganPengantar     = new AlihTanganPengantarModel();
        $this->mAlihtanganKegiatan      = new AlihTanganKegiatanModel();
    }

    public function create($id)
    {
        $alihtangan_kegiatan       = $this->mAlihtanganKegiatan->where('id', $id)->first();

        $kepsek = $this->mKepsek->where('idPSekolah', session()->get('idPSekolah'))->get();
        $periode = $this->mPeriode->get();
        $konselor = $this->mKonselor->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'url2'                  => $this->url2,
            'page'                  => 'Tambah Data Layanan Alih Tangan Pengantar',
            'alihtangan_kegiatan'   => $alihtangan_kegiatan,
            'kepsek'                => $kepsek,
            'konselor'              => $konselor,
            'periode'               => $periode,
        ];
        return view($this->views . "/create", $data);
    }

    // public function update(Request $request, $id)
    public function store(Request $request, $id)
    {
        $alihtangan_kegiatan       = $this->mAlihtanganKegiatan->where('id', $id)->first();
        $siswa      = $this->mSiswa->where('id', $alihtangan_kegiatan['idSiswa'])->first();
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };

        $whereKep = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'status'        => 1
        ];
        $kepsek = $this->mKepsek->where($whereKep)->first();
        if(!isset($kepsek)){
            return redirect("$this->url")->with('gagal', 'Kepsek belum di set');
        };

        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));
        
        $dataAlihPengantar = [
            'idLAKegiatan'          => $id,
            'idSKepsek'             => $kepsek['id'],
            'idSKonselor'           => $konselor['id'],
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_yth'             => $request->isian_yth,
            'isian_permasalahan'    => $request->isian_permasalahan,
            'isian_keterangan'      => $request->isian_keterangan,
        ];
        $this->mAlihtanganPengantar->create($dataAlihPengantar);
        $dataStatus = [
            'status'    => 2 // update semua statusya jadi 0
        ];
        // cari yang statusnya 1, terus semua diupdate jadi 0
        // dd($dataHomevisitTu); die();
        $this->mAlihtanganKegiatan->where('id', $id)->update($dataStatus);
        return redirect("$this->url2")->with('sukses', 'Data Alih Tangan Pengantar berhasil di tambahkan');
    }

    public function show($id)
    {
        $alihtangan_pengantar = $this->mAlihtanganPengantar->where('id', $id)->first();
        
        $data = [
            'title'                     => $this->title,
            'url'                       => $this->url,
            'url2'                      => $this->url2,
            'page'                      => 'Data Layanan Alih Tangan Pengantar',
            'alihtangan_pengantar'      => $alihtangan_pengantar,
        ];
        return view($this->views . "/show", $data);
    }

    // public function store(Request $request)
    public function download(Request $request)
    {
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $alihtangan_pengantar = $this->mAlihtanganPengantar->where('id', $request->id)->first();
        // dd($mundur);
        
        $dataAlihPengantar = [
            'KopSurat'              => $sekolah->logo,
            'idPKKode'              => $alihtangan_pengantar->alihkegiatan->kelaskode->kelas->nama.' '.$alihtangan_pengantar->alihkegiatan->kelaskode->kelas->jurusan->nama.' '.$alihtangan_pengantar->alihkegiatan->kelaskode->nama,
            'idSiswa'               => $alihtangan_pengantar->alihkegiatan->siswa->nama,
            'namaKepsek'            => $alihtangan_pengantar->kepsek->guru->nama ?? 'Kepsek belum di SET',
            'nipKepsek'             => $alihtangan_pengantar->kepsek->guru->nip ?? 'Kepsek belum di SET',
            'namaKonselor'          => $alihtangan_pengantar->konselor->guru->nama ?? 'Guru Konseling belum di SET',
            'nipKonselor'           => $alihtangan_pengantar->konselor->guru->nip ?? 'Guru Konseling belum di SET',
            'surat_tempat'          => $alihtangan_pengantar->surat_tempat,
            'surat_waktu'           => $alihtangan_pengantar->surat_waktu,
            'isian_yth'             => $alihtangan_pengantar->isian_yth,
            'isian_permasalahan'    => $alihtangan_pengantar->isian_permasalahan,
            'isian_keterangan'      => $alihtangan_pengantar->isian_keterangan,
        ];
        $templateProcessor = new TemplateProcessor('word-template/alih_tangan/satuan_alihtangan_pengantar.docx'); // load template word
        $templateProcessor->setImageValue('KopSurat', array('path' => "upload/logo_sekolah/".$dataAlihPengantar['KopSurat'], 'width' => 500, 'height' => 200, 'ratio' => true));
        $templateProcessor->setValue('namaSiswa', $dataAlihPengantar['idSiswa']); 
        $templateProcessor->setValue('kelasSiswa', $dataAlihPengantar['idPKKode']); 
        $templateProcessor->setValue('isian_yth', $dataAlihPengantar['isian_yth']); 
        $templateProcessor->setValue('isian_permasalahan', $dataAlihPengantar['isian_permasalahan']);
        $templateProcessor->setValue('isian_keterangan', $dataAlihPengantar['isian_keterangan']); 
        $templateProcessor->setValue('suratTempat', $dataAlihPengantar['surat_tempat']); 
        $templateProcessor->setValue('tanggalSurat', $dataAlihPengantar['surat_waktu']);
        $templateProcessor->setValue('namaKepsek', $dataAlihPengantar['namaKepsek']);
        $templateProcessor->setValue('nipKepsek', $dataAlihPengantar['nipKepsek']);
        $templateProcessor->setValue('namaKonselor', $dataAlihPengantar['namaKonselor']);
        $templateProcessor->setValue('nipKonselor', $dataAlihPengantar['nipKepsek']);
        $fileName = 'RENCANA PELAYANAN BIMBINGAN KONSELING ALIH TANGAN PENGANTAR'; // nama filenya
        

        // biar bisa dunlud
        $templateProcessor->saveAs($fileName . '.docx');
        return response()->download($fileName . '.docx')->deleteFileAfterSend(true);
        // dd($dataTartib);
    }
}
