<?php

namespace App\Http\Controllers\Admin\Layanan\Alihtangan;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use PhpOffice\PhpWord\TemplateProcessor;

use App\Models\Master\PeriodeModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Perpus\JurusanModel;

use App\Models\Stakeholder\KepsekModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Stakeholder\GuruModel;

use App\Models\Siswa\SiswaModel;

use App\Models\Layanan\Alihtangan\AlihTanganRplModel;
use App\Models\Layanan\Alihtangan\AlihTanganPengantarModel;
use App\Models\Layanan\Alihtangan\AlihTanganKegiatanModel;

class AlihtanganKegiatanController extends Controller
{
    private $views      = 'admin/layanan/alihtangan/alihtangan_kegiatan';
    private $url        = 'admin/layanan/lainnya/alih-tangan/kegiatan';
    private $url2       = 'admin/layanan/lainnya/alih-tangan/rpl';
    private $url3       = 'admin/layanan/lainnya/alih-tangan/pengantar';
    private $title      = 'Halaman Alih Tangan RPL';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPeriode                 = New PeriodeModel();
        
        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mKelasKode               = new KelasKodeModel();
        $this->mPerpusSekolah           = new SekolahModel();

        $this->mKepsek                  = New KepsekModel();
        $this->mKonselor                = New KonselorModel();
        $this->mGuru                    = New GuruModel();

        $this->mSiswa                   = New SiswaModel();

        $this->mAlihtanganRpl           = new AlihTanganRplModel();
        $this->mAlihtanganPengantar     = new AlihTanganPengantarModel();
        $this->mAlihtanganKegiatan      = new AlihTanganKegiatanModel();
    }

    public function index()
    {
        $wherenyaa = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
        ];
        $alihtangan_kegiatan      = $this->mAlihtanganKegiatan->where($wherenyaa)->get();

        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'page'                  => 'Data Alih Tangan Kegiatan',
            'alihtangan_kegiatan'   => $alihtangan_kegiatan,
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $periode = $this->mPeriode->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Alih Tangan Kegiatan',
            'periode'       => $periode,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $whereKep = [
            'status' => 1,
            'idPSekolah' => session()->get('idPSekolah')
        ];
        $kepsek   = $this->mKepsek->where($whereKep)->first();
        if(!isset($kepsek)){
            return redirect("$this->url")->with('gagal', 'Kepsek belum di set');
        };
        
        $siswa = $this->mSiswa->where('id', $request->idSiswa)->first();
        $kelas = $this->mKelasKode->where('id', $siswa['idPKKode']);
        if(!isset($kelas)){
            return redirect("$this->url")->with('gagal', 'Indeks Kelas tidak ditemukan');
        };
        $whereKons = [
            'id'            => $siswa['idSKonselor'],
            'status'        => 1,
        ];
        $konselor   = $this->mKonselor->where($whereKons)->first();
        if(!isset($konselor)){
            return redirect("$this->url")->with('gagal', 'Guru Konseling belum di set atau tidak aktif');
        };

        $suratWaktu = $request->surat_waktu;  
        $suratWaktunew = date("d-m-Y", strtotime($suratWaktu));

        $dataAlihKegiatan = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idSKonselor'   => session()->get('idSKonselor'),
            'idPKKode'      => $request->idPKKode,
            'idPPeriode'    => session()->get('idPPeriode'),
            'idSiswa'       => $request->idSiswa,
            'kode_unik'     => strtoupper(bin2hex(random_bytes(3))),
            'status'        => 1
        ];
        $alihtangan_kegiatan = $this->mAlihtanganKegiatan->create($dataAlihKegiatan);
        $dataAlihRpl = [
            'idLAKegiatan'          => $alihtangan_kegiatan['id'], // untuk mmebuat relasi yang baik
            'idSKepsek'             => $kepsek['id'],
            'idSKonselor'           => $konselor['id'],
            'surat_tempat'          => $request->surat_tempat,
            'surat_waktu'           => $suratWaktunew,
            'isian_judul'           => $request->isian_judul,
            'isian_bidang'          => $request->isian_bidang,
            'isian_fungsi'          => $request->isian_fungsi,
            'isian_tujuan'          => $request->isian_tujuan,
            'isian_hasil'           => $request->isian_hasil,
            'isian_gambaran'        => $request->isian_gambaran,
            'isian_darikepada'      => $request->isian_darikepada,
            'isian_alasan'          => $request->isian_alasan,
            'isian_tanggal'         => $request->isian_tanggal,
            'isian_semester'        => $request->isian_semester,
            'isian_bahan'           => $request->isian_bahan,
            'isian_rencana'         => $request->isian_rencana,
            'isian_catatan'         => $request->isian_catatan,
        ];
        $this->mAlihtanganRpl->create($dataAlihRpl);
        return redirect("$this->url")->with('sukses', 'Data Layanan Alih Tangan Kasus berhasil di tambahkan');
    }

    public function show($id)
    {
        // Get Data
        $alihtangan_kegiatan        = $this->mAlihtanganKegiatan->where('kode_unik', $id)->first();
        $alihtangan_rpl             = $this->mAlihtanganRpl->where('idLAKegiatan', $alihtangan_kegiatan['id'])->first();
        
        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'url2'                  => $this->url2,
            'url3'                  => $this->url3,
            'page'                  => 'Detail Data Alihtangan RPL',
            'id'                    => $id,
            'alihtangan_rpl'        => $alihtangan_rpl,
            'alihtangan_kegiatan'   => $alihtangan_kegiatan,
        ];
        if ($alihtangan_kegiatan['status'] == 2){
            $alihtangan_pengantar               = $this->mAlihtanganPengantar->where('idLAKegiatan', $alihtangan_kegiatan['id'])->first();
            $data['alihtangan_pengantar']       = $alihtangan_pengantar;
        }
        // echo json_encode($konrpl); die;

        return view($this->views . "/show", $data);
    }
}
