<?php

namespace App\Http\Controllers\Admin\Import;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


// use App\Imports\LulusanImport;
// use App\Exports\LulusanExport;
use Maatwebsite\Excel\Facades\Excel;

// Panggil Nama file Model yang mau dipake
use App\Models\MImportexcelSiswaModel;

use App\Models\MPerpusKelasKodeModel;
use App\Models\MPerpusJurusanModel;
use App\Models\MPerpusKelasModel;
use App\Models\MPeriodeModel;
use App\Models\MAgamaModel;
use App\Models\MOrtuModel;
use App\Models\MSekolahWaliModel;
use App\Models\MSiswaModel;
use App\Models\MSiswaMutasiModel;
use App\Models\MPekerjaanModel;
use App\Models\MKonselorModel;
use App\Models\MTempatModel;

use Illuminate\Support\Facades\Crypt;

class ImportSiswaKelasController extends Controller
{
    
    private $views      = 'adminSekolah/importSiswaKelas';
    private $url        = 'sekolah/import_siswaKelas';
    private $title      = 'Halaman Import Siswa';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mExcelSiswa          = new MImportexcelSiswaModel();
        $this->mPerpusKelasKode     = new MPerpusKelasKodeModel();
        $this->mPerpusJurusan           = new MPerpusJurusanModel();
        $this->mPerpusKelas             = new MPerpusKelasModel();
        $this->mPeriode             = new MPeriodeModel();
        $this->mAgama               = new MAgamaModel();
        $this->mOrtu                = new MOrtuModel();
        $this->mSiswa               = new MSiswaModel();
        $this->mSiswaMutasi         = new MSiswaMutasiModel();
        $this->mSekolahWali         = new MSekolahWaliModel();
        $this->mPekerjaan           = new MPekerjaanModel();
        $this->mKonselor            = new MKonselorModel();
        $this->mTempat              = new MTempatModel();
    }

    public function index()
    {
        // $guru = $this->mGuru->get();
        $excelSiswa     = $this->mExcelSiswa->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Import Siswa',
            'excelSiswa'    => $excelSiswa,
        ];
        return view($this->views . "/index", $data);
        // dd(session()->all());
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // echo json_encode(enc()); die;
        // echo json_encode(\globalhelper::enc()); die;

        $perpus_kelasKode      = $this->mPerpusKelasKode->where('id', $id)->first();
        $perpus_jurusan     = $this->mPerpusJurusan->where('id', $id)->first();
        $perpus_kelas       = $this->mPerpusKelas->where('id', $id)->first();
        $agama      = $this->mAgama->get();
        $pekerjaan  = $this->mPekerjaan->get();
        $konselor   = $this->mKonselor->where('idPSekolah', session()->get('idPSekolah'))->get();
        $tempat     = $this->mTempat->get();
        $periode    = $this->mPeriode->where('id', session()->get('idPPeriode'))->first();

        // echo json_encode($konselor); die;
        // dd(session()->all());

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Import Excel Siswa ' . $perpus_kelasKode->kelas->nama.' '.$perpus_kelasKode->kelas->jurusan->nama.' '.$perpus_kelasKode->nama,
            'perpus_kelasKode'  => $perpus_kelasKode,
            'agama'             => $agama,
            'pekerjaan'         => $pekerjaan,
            'konselor'          => $konselor,
            'tempat'            => $tempat,
            'periode'           => $periode,
        ];

        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // validasi
        $validateData = $request->validate([
            'file_excel'                    => 'required|mimes:csv,xls,xlsx'
        ],[
            'file_excel.required'           => 'Pilih file terlebih dahulu',
            'file_excel.mimes'              => 'Format data harus csv, xls atau xlsx',
        ]);

        // Library Import Excel
		$file = $validateData['file_excel'];
        $collection = Excel::toCollection(collect([]), $file); // ke convert collection

        foreach ($collection[0] as $row) {
            // skip header

            $i=0;
            if($i <> 1) {
            
                if ($row[0] == 'id kelas')
                    continue;

                // ambil dari excel
                $idMAgama           = desc($row[0]);
                $idMStatus          = 1; //Langsung aktif
                $idSKonselor        = desc($row[1]);
                $nisn               = $row[2];
                $nama               = $row[3];
                $lahir_tanggal      = $row[4];
                $lahir_tempat       = $row[5];

                $idPPKelas          = 1; // Langsung Sesuai Periode Sekarang
                $idPPStatus         = 1; // Langsung Sesuai Periode Sekarang
                $idMTempat          = desc($row[6]);

             
                $dataSiswa = [
                    'idMAgama'          => $idMAgama,
                    'idMStatus'         => $idMStatus,
                    'idSKonselor'       => $idSKonselor,
                    'nisn'              => $nisn,
                    'nama'              => $nama,
                    'lahir_tanggal'     => $lahir_tanggal,
                    'lahir_tempat'      => $lahir_tempat,
                    'idPPKelas'         => $idPPKelas, 
                    'idPPStatus'        => $idPPStatus,
                    'idMTempat'         => $idMTempat,
                ];
                // echo json_encode($dataSiswa);
                // dd($dataSiswa);
                $siswa = $this->mSiswa->create($dataSiswa);

                // tambah mutasi
                $dataSiswaMutasi = [
                    'idSiswa'       => $siswa['id'],
                    'idPKKode'      => $idPKKode,
                    'idPPeriode'    => session()->get('idPPeriode'),
                    'idMStatus'     => $idMStatus,
                ];
                $this->mSiswaMutasi->create($dataSiswaMutasi);

                $namaOrtu           = $row[9];
                $alamatOrtu         = $row[10];
                $idMPekerjaan       = desc($row[11]);

                $dataOrtu = [
                    'idSiswa'       => $siswa['id'],
                    'idMPekerjaan'  => $idMPekerjaan,
                    'nama'          => $namaOrtu,
                    'alamat'        => $alamatOrtu,
                ];
                // echo json_encode($dataOrtu);
                $this->mOrtu->create($dataOrtu);
            }
            $i++;
        }
        
        $recordImport = [
            'idUser'        => session()->get('users_id'),
            'idPSekolah'    => session()->get('idPSekolah'),
            'idPPeriode'    => session()->get('idPPeriode'),
        ];
        $this->mExcelSiswa->create($recordImport);

        // $guru = $this->mGuru->get();
        $excelSiswa     = $this->mExcelSiswa->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Import Siswa',
            'excelSiswa'    => $excelSiswa,
        ];
        return view($this->views . "/index", $data);
    }

    public function destroy($id)
    {
        //
    }
}