<?php

namespace App\Http\Controllers\Admin\Import;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


// use App\Imports\LulusanImport;
// use App\Exports\LulusanExport;
use Maatwebsite\Excel\Facades\Excel;

use App\Models\Import\ImportexcelSiswaModel;

use App\Models\Perpus\KelasKodeModel;
use App\Models\Master\PeriodeModel;
use App\Models\Master\AgamaModel;
use App\Models\Siswa\OrtuModel;
use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Siswa\SiswaModel;
use App\Models\Siswa\SiswaMutasiModel;
use App\Models\Master\PekerjaanModel;
use App\Models\Stakeholder\KonselorModel;
use App\Models\Master\TempatModel;

use Illuminate\Support\Facades\Crypt;

class ImportSiswaController extends Controller
{
    
    private $views      = 'admin/import/importSiswa';
    private $url        = 'admin/import/siswa';
    private $title      = 'Halaman Import Siswa';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mExcelSiswa          = new ImportexcelSiswaModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();
        $this->mPeriode             = new PeriodeModel();
        $this->mAgama               = new AgamaModel();
        $this->mOrtu                = new OrtuModel();
        $this->mSiswa               = new SiswaModel();
        $this->mSiswaMutasi         = new SiswaMutasiModel();
        $this->mSekolahWali         = new SekolahWaliModel();
        $this->mPekerjaan           = new PekerjaanModel();
        $this->mKonselor            = new KonselorModel();
        $this->mTempat              = new TempatModel();
    }

    public function index()
    {
        // $guru = $this->mGuru->get();
        $excelSiswa     = $this->mExcelSiswa->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Import Siswa',
            'excelSiswa'    => $excelSiswa,
        ];
        return view($this->views . "/index", $data);
        // dd(session()->all());
    }

    public function create()
    {
        // echo json_encode(enc()); die;
        // echo json_encode(\globalhelper::enc()); die;

        $kelaskode  = $this->mPerpusKelasKode->get();
        $agama      = $this->mAgama->get();
        $pekerjaan  = $this->mPekerjaan->get();
        $konselor   = $this->mKonselor->where('idPSekolah', session()->get('idPSekolah'))->get();
        $tempat     = $this->mTempat->get();
        $periode    = $this->mPeriode->where('id', session()->get('idPPeriode'))->first();

        // echo json_encode($konselor); die;
        // dd(session()->all());

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Import Excel Siswa',
            'kelaskode'     => $kelaskode,
            'agama'         => $agama,
            'pekerjaan'     => $pekerjaan,
            'konselor'      => $konselor,
            'tempat'        => $tempat,
            'periode'       => $periode,
        ];

        return view($this->views . "/create", $data);


        // $encrypted = Crypt::encryptString('12');
		// $decrypted = Crypt::decryptString($encrypted);
 
		// echo "Hasil Enkripsi : " . $encrypted;
		// echo "<br/>";
		// echo "<br/>";
		// echo "Hasil Dekripsi : " . $decrypted;
    }

    public function store(Request $request)
    {
        // validasi
        $validateData = $request->validate([
            'file_excel'                    => 'required|mimes:csv,xls,xlsx'
        ],[
            'file_excel.required'           => 'Pilih file terlebih dahulu',
            'file_excel.mimes'              => 'Format data harus csv, xls atau xlsx',
        ]);

        // Library Import Excel
		$file = $validateData['file_excel'];
        $collection = Excel::toCollection(collect([]), $file); // ke convert collection

        foreach ($collection[0] as $row) {
            // skip header

            $i=0;
            if($i <> 1) {
            
                if ($row[0] == 'id kelas')
                    continue;

                // ambil dari excel
                $idPKKode           = desc($row[0]);
                $idMAgama           = desc($row[1]);
                $idMStatus          = 1; //Langsung aktif
                $idSKonselor        = desc($row[2]);
                $nisn               = $row[3];
                $nama               = $row[4];
                $lahir_tanggal      = $row[5];
                $lahir_tempat       = $row[6];

                $idPPKelas          = 1; // Langsung Sesuai Periode Sekarang
                $idPPStatus         = 1; // Langsung Sesuai Periode Sekarang
                $idMTempat          = desc($row[7]);

             
                $dataSiswa = [
                    'idPSekolah'        => session()->get('idPSekolah'),
                    'idPKKode'          => $idPKKode,
                    'idMAgama'          => $idMAgama,
                    'idPPeriode'        => session()->get('idPPeriode') ?? '',
                    'idMStatus'         => $idMStatus,
                    'idSKonselor'       => $idSKonselor,
                    'nisn'              => $nisn,
                    'nama'              => $nama,
                    'lahir_tanggal'     => $lahir_tanggal,
                    'lahir_tempat'      => $lahir_tempat,
                    'idPPKelas'         => $idPPKelas, 
                    'idPPStatus'        => $idPPStatus,
                    'idMTempat'         => $idMTempat,
                ];
                // echo json_encode($dataSiswa);
                // dd($dataSiswa);
                $siswa = $this->mSiswa->create($dataSiswa);

                // tambah mutasi
                $dataSiswaMutasi = [
                    'idSiswa'       => $siswa['id'],
                    'idPKKode'      => $idPKKode,
                    'idPPeriode'    => session()->get('idPPeriode') ?? '',
                    'idMStatus'     => $idMStatus,
                ];
                $this->mSiswaMutasi->create($dataSiswaMutasi);

                $namaOrtu           = $row[8];
                $alamatOrtu         = $row[9];
                $idMPekerjaan       = desc($row[10]);

                $dataOrtu = [
                    'idSiswa'       => $siswa['id'],
                    'idMPekerjaan'  => $idMPekerjaan,
                    'nama'          => $namaOrtu,
                    'alamat'        => $alamatOrtu,
                ];
                // echo json_encode($dataOrtu);
                $this->mOrtu->create($dataOrtu);
            }
            $i++;
        }
        
        $recordImport = [
            'idUser'        => session()->get('users_id'),
            'idPSekolah'    => session()->get('idPSekolah'),
            'idPPeriode'    => session()->get('idPPeriode') ?? '',
        ];
        $this->mExcelSiswa->create($recordImport);

        // $guru = $this->mGuru->get();
        $excelSiswa     = $this->mExcelSiswa->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Import Siswa',
            'excelSiswa'    => $excelSiswa,
        ];
        returnredirect("$this->url")->with('sukses', 'Data Siswa berhasil di import');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // 
    }

    public function update(Request $request, $id)
    {
        // 
    }

    public function destroy($id)
    {
        //
    }
}
